/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops.beans;

import com.ibm.hwmca.fw.schedops.DisplayData;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.text.DateFormat;

public class SchedOpsDetailsBean
extends PanelBean
implements DataBean {
    private static final String CLASS_NAME = "[SchedOpsDetailsBean] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String SCHEDBY = "XTIM.SCHEDBY";
    private static final String TEXT_DAY = "XTIM.DAY";
    private static final String TEXT_DAYS = "XTIM.DAYS";
    private static final String TEXT_HOUR = "XTIM.HOUR";
    private static final String TEXT_HOURS = "XTIM.HOURS";
    private static final String TEXT_INDEFINITE = "XTIM.INDEFINITE";
    private static final String TEXT_MINUTE = "XTIM.MINUTE";
    private static final String TEXT_MINUTES = "XTIM.MINUTES";
    private static final String TEXT_SECOND = "XTIM.SECOND";
    private static final String TEXT_SECONDS = "XTIM.SECONDS";
    private static final String USERID1 = "XTIM.USERID1";
    private static final String USERID2 = "XTIM.USERID2";
    private static final String CANCEL = "CANCEL";
    private static final String OK_BUTTON = "OKButton";
    private static final String ONE_BLANK = " ";
    private String m_sObjectOutput;
    private String m_sOperationOutput;
    private String m_sWinBeginsDateOutput;
    private String m_sWinBeginsTimeOutput;
    private String m_sWinLenOutput;
    private String m_sRemainingRepOutput;
    private String m_sTimeIntervalOutput;
    private String m_sOperWasSchedMsgOutput;
    private DisplayData displayData;

    public SchedOpsDetailsBean(String name, DisplayData data) {
        Trace.trace(TRACE_MASKF, "[SchedOpsDetailsBean] <> SchedOpsDetailsBean() : Name = " + name);
        this.setBeanName(name);
        this.displayData = data;
    }

    public void prepare() {
        String userid;
        DateFormat dateFormat = null;
        DateFormat timeFormat = null;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            dateFormat = DateFormat.getDateInstance(1, userContext.getLocale());
            dateFormat.setTimeZone(userContext.getTimeZone());
            timeFormat = DateFormat.getTimeInstance(1, userContext.getLocale());
            timeFormat.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            dateFormat = DateFormat.getDateInstance(1);
            timeFormat = DateFormat.getTimeInstance(1);
        }
        this.setObjectOutput(this.displayData.getObjectName().toString());
        this.setOperationOutput(this.displayData.getOperationDescription().toString());
        this.setWinBeginsDateOutput(dateFormat.format(this.displayData.getScheduledDate()));
        this.setWinBeginsTimeOutput(timeFormat.format(this.displayData.getScheduledDate()));
        long minutes = Math.round(this.displayData.getWindowOfOpportunity() / 60000L);
        this.setWinLenOutput(Integer.toString((int)minutes) + ONE_BLANK + (minutes > 1L ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_MINUTES).toString() : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_MINUTE).toString()));
        long reps = this.displayData.getRemainingRepetitions();
        String sReps = reps >= 0L ? Integer.toString((int)reps) : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_INDEFINITE).toString();
        this.setRemainingRepOutput(sReps);
        long freq = this.displayData.getSchedulingFrequency();
        int days = (int)(freq / 86400000L);
        int hours = (int)(freq % 86400000L / 3600000L);
        int mins = (int)(freq % 3600000L / 60000L);
        int secs = (int)(freq % 60000L / 1000L);
        StringBuffer buffer = new StringBuffer();
        if (days > 0) {
            buffer.append(Integer.toString(days));
            buffer.append(ONE_BLANK);
            buffer.append(days == 1 ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_DAY).toString() : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_DAYS).toString());
            buffer.append(ONE_BLANK);
        }
        if (hours > 0) {
            buffer.append(Integer.toString(hours));
            buffer.append(ONE_BLANK);
            buffer.append(hours == 1 ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_HOUR).toString() : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_HOURS).toString());
            buffer.append(ONE_BLANK);
        }
        if (mins > 0) {
            buffer.append(Integer.toString(mins));
            buffer.append(ONE_BLANK);
            buffer.append(mins == 1 ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_MINUTE).toString() : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_MINUTES).toString());
            buffer.append(ONE_BLANK);
        }
        if (secs > 0) {
            buffer.append(Integer.toString(secs));
            buffer.append(ONE_BLANK);
            buffer.append(secs == 1 ? new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_SECOND).toString() : new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TEXT_SECONDS).toString());
            buffer.append(ONE_BLANK);
        }
        this.setTimeIntervalOutput(buffer.toString());
        if (this.displayData.getCreationUserid() == null) {
            Object[] subst = new String[]{this.displayData.getCreationInterface().toString()};
            userid = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", USERID1, subst).toString();
        } else {
            Object[] subst = new String[]{this.displayData.getCreationInterface().toString(), this.displayData.getCreationUserid().toString()};
            userid = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", USERID2, subst).toString();
        }
        String netid = this.displayData.getCreationSourceNetID().toString();
        String name = this.displayData.getCreationSourceName().toString();
        DateFormat format = null;
        try {
            ClientUserContext userContext = ClientUserContext.getUserContext();
            format = DateFormat.getDateTimeInstance(1, 1, userContext.getLocale());
            format.setTimeZone(userContext.getTimeZone());
        }
        catch (NullContextException e) {
            format = DateFormat.getDateTimeInstance(1, 1);
        }
        String date = format.format(this.displayData.getCreationDate());
        LocalizableText schedby = new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", SCHEDBY, new String[]{userid, name, date});
        this.setOperWasSchedMsgOutput(schedby.toString());
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "[SchedOpsDetailsBean] >> panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        String elementName = event.getElementName();
        String actionCommand = event.getActionCommand();
        if (actionCommand.endsWith(OK_BUTTON)) {
            this.sendTaskletRequest(actionCommand, null);
        } else if (actionCommand.endsWith(CANCEL)) {
            this.sendTaskletRequest(actionCommand, null);
        } else {
            Trace.trace(TRACE_MASKF, "[SchedOpsDetailsBean] \tUnknown event received...");
        }
        Trace.trace(TRACE_MASKT, "<< panelAction()");
    }

    private void sendTaskletRequest(String actionCommand, Object data) {
        PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName() + '.' + actionCommand);
        request.setData("SOURCE", this.getBeanName());
        request.setData("ACTION", actionCommand);
        request.setData("DATA", data);
        this.postTaskletRequest(request);
    }

    public String getObjectOutput() {
        return this.m_sObjectOutput;
    }

    public void setObjectOutput(String s) throws IllegalUserDataException {
        this.m_sObjectOutput = s;
    }

    public String getOperationOutput() {
        return this.m_sOperationOutput;
    }

    public void setOperationOutput(String s) throws IllegalUserDataException {
        this.m_sOperationOutput = s;
    }

    public String getWinBeginsDateOutput() {
        return this.m_sWinBeginsDateOutput;
    }

    public void setWinBeginsDateOutput(String s) throws IllegalUserDataException {
        this.m_sWinBeginsDateOutput = s;
    }

    public String getWinBeginsTimeOutput() {
        return this.m_sWinBeginsTimeOutput;
    }

    public void setWinBeginsTimeOutput(String s) throws IllegalUserDataException {
        this.m_sWinBeginsTimeOutput = s;
    }

    public String getWinLenOutput() {
        return this.m_sWinLenOutput;
    }

    public void setWinLenOutput(String s) throws IllegalUserDataException {
        this.m_sWinLenOutput = s;
    }

    public String getRemainingRepOutput() {
        return this.m_sRemainingRepOutput;
    }

    public void setRemainingRepOutput(String s) throws IllegalUserDataException {
        this.m_sRemainingRepOutput = s;
    }

    public String getTimeIntervalOutput() {
        return this.m_sTimeIntervalOutput;
    }

    public void setTimeIntervalOutput(String s) throws IllegalUserDataException {
        this.m_sTimeIntervalOutput = s;
    }

    public String getOperWasSchedMsgOutput() {
        return this.m_sOperWasSchedMsgOutput;
    }

    public void setOperWasSchedMsgOutput(String s) throws IllegalUserDataException {
        this.m_sOperWasSchedMsgOutput = s;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.m_sObjectOutput = "";
        this.m_sOperationOutput = "";
        this.m_sWinBeginsDateOutput = "";
        this.m_sWinBeginsTimeOutput = "";
        this.m_sWinLenOutput = "";
        this.m_sRemainingRepOutput = "";
        this.m_sTimeIntervalOutput = "";
        this.m_sOperWasSchedMsgOutput = "";
    }
}

